<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

	/* This function converts certificate to another format, currently available
	 * formats are PEM and DER.
	 */
	function convert_cert($inform,$outform,$cert) {
		$inform = strtolower($inform);
		$outform = strtolower($outform);
		switch($inform) {
			case 'pem':
				if($outform === 'pem') { return $cert; }
				else if($outform === 'der') { return pem2der($cert); }
				else { return FALSE; }
				break;
			case 'der':
				if($outform === 'der') { return $cert; }
				else if($outform === 'pem') { return der2pem($cert); }
				else { return FALSE; }
				break;
			default:
				return FALSE;
		}
	}
	
	/* This function converts a PEM encoded certificate to DER encoding
	 */
	function pem2der($pem_data) {
	   $begin = "CERTIFICATE-----";
	   $end   = "-----END";
	   $pem_data = substr($pem_data, strpos($pem_data, $begin)+strlen($begin));    
	   $pem_data = substr($pem_data, 0, strpos($pem_data, $end));
	   $der = base64_decode($pem_data);
	   return $der;
	}
	
	/* This function converts a DER encoded certificate to PEM encoding
	 */
	function der2pem($der_data) {
	   $pem = chunk_split(base64_encode($der_data), 64, "\n");
	   $pem = "-----BEGIN CERTIFICATE-----\n".$pem."-----END CERTIFICATE-----\n";
	   return $pem;
	}
	
	/* This function cleans up the certificate string provided by the server so that it can be parsed by OpenSSL.
	 */
	function clean_cert_string($cert) {
		$output = preg_replace("/-----[A-Z]+\sCERTIFICATE-----/","",$cert);
		$output = preg_replace("!\s+!"," ",$output);
		$cert = str_replace(" ","\n",$output);
		$cert = "-----BEGIN CERTIFICATE-----\n".trim($cert)."\n-----END CERTIFICATE-----";
		return $cert;
	}
	
	/* This function determines if a string is a valid roman numeral. This is used in parsing names from CAC certs.
	 */
	function is_roman_numeric($str) {
		preg_match ('/^M{0,4}(CM|CD|D?C{0,3})(XC|XL|L?X{0,3})(IX|IV|V?I{0,3})$/',$str,$matches);
		if(count($matches) > 0) { return TRUE; }
		return FALSE;
	}